# Clculo de los estadsticos bsicos

########################################################
# Seccin modificable por el usuario
########################################################

# Lectura de la base de datos.
datos<-read.csv2("Cuadro II.5.V.csv",enc="latin1")

# Seleccin de variables a trabajar

variables<-c("M1","M2","M6","M12")
#variables<-c("M1","M2","M3","M4","M5","M6","M7","M8","M9","M10","M11","M12","M13","M14","M15","M16","M19","M20","M21","M22","M23","M24","M25","M26","M27","M30","M31","M32")

# Seleccin de la o las variables de agrupacin
#agrupa<-NULL
agrupa<-c("Especie")
#agrupa<-c("Orden","Familia")
#agrupa<-c("Orden","Familia","Gnero")

# Grado de recorte de la media acotada
recorte<-0.05

# Vector de cuantiles que se quieren calcular
cuantiles<-c(0.025,0.05,0.95,0.975)

# Nombre del archivo de salida
nombreArchivoSalida<-"Salida Cuadro II.5.V.csv"

# Seleccion de las variables para obtener el promedio ponderado
# Si es nula no se realiza el procedimiento de la media ponderada
#variablespondera<-NULL
#variablespondera<-c("M2")
variablespondera<-c("M6","M12")

# Seleccin de la variables de ponderacin
# Si es nula no se realiza el procedimiento de la media ponderada
#variablepeso<-NULL
variablepeso<-c("M1")
#variablepeso<-c("M2","M12")

# Seleccin de la o las variables de agrupacin por la cual se quiere obtener la ponderacin
#agrupapondera<-NULL
agrupapondera<-c("Especie")
#agrupapondera<-c("Orden","Familia")

# Nombre del archivo de salida para los promedios ponderados
nombreArchivoSalidaPondera<-"Salida Cuadro II.5.V.Media ponderada.csv"



########################################################
# Seccin que realiza el procedimiento
########################################################

# Bibliotecas que debe utilizar
library(psych)
library(e1071)


estadisticos<-function(datos){
 # Biblioteca requerida para la funcin 
 require(psych)
 require(e1071)
 # Funciones auxiliares para el clculo de los estadsticos
 numTot<-function(x) length(x)
 numNA<-function(x) sum(!is.na(x))
 geometric.mean2<-function(x) geometric.mean(x[!is.na(x)])
 harmonic.mean2<-function(x) harmonic.mean(x[!is.na(x)])
 Cmoda<-function(x){
  x<-x[!is.na(x)]
  t<-table(x)
  modas<-as.numeric(names(t[t==max(t)]))
  if (length(modas)==1) return(modas) else return(NA) 
 }
 Tmoda<-function(x){
   x<-x[!is.na(x)]
   t<-table(x)
   modas<-as.numeric(names(t[t==max(t)]))
   if (length(modas)==1) return("Moda nica") else {
      if (length(modas)==length(x)) return("No hay moda") else return("Modas mltiples")
   }
 }
 dma<-function(x){
   x<-x[!is.na(x)]
   return(mean(abs(x-mean(x))))
 }
 dmeda<-function(x){
   x<-x[!is.na(x)]
   return(mean(abs(x-median(x))))
 }
 famplitud<-function(x) diff(range(x,na.rm=TRUE))
 eestd<-function(x) sd(x,na.rm=TRUE)/sqrt(length(x[!is.na(x)]))
 coefvar<-function(x) (sd(x,na.rm=TRUE)*100)/mean(x,na.rm=TRUE)
 Var<-function(X){
   X<-X[!is.na(X)]
   return(sum(((X-mean(X))^2)/length(X)))
 }
 Sd<-function(X){
   X<-X[!is.na(X)]
   return(sqrt(sum(((X-mean(X))^2)/length(X))))
 }
 if (is.vector(datos)){
  datos<-data.frame(datos)
 }
 # Aplicacin de los estadsticos por filas
 N<-apply(datos,2,numTot)
 noNA<-apply(datos,2,numNA)
 minimo<-apply(datos,2,min,na.rm=TRUE)
 maximo<-apply(datos,2,max,na.rm=TRUE)
 media<-apply(datos,2,mean,na.rm=T)
 mediaAcotada<-apply(datos,2,mean,na.rm=T,trim=recorte)
 mediaGeometrica<-apply(datos,2,geometric.mean2)
 mediaArmonica<-apply(datos,2,harmonic.mean2)
 mediana<-apply(datos,2,median,na.rm=TRUE)
 moda<-apply(datos,2,Cmoda)
 tipo.de.moda<-apply(datos,2,Tmoda)
 amplitud<-apply(datos,2,famplitud)
 cuasivarianza<-apply(datos,2,var,na.rm=TRUE)
 varianza<-apply(datos,2,Var)
 cuasidesviacion.estandar<-apply(datos,2,sd,na.rm=TRUE)
 desviacion.estandar<-apply(datos,2,Sd)
 desviacion.absoluta.media<-apply(datos,2,dma)
 desviacion.absoluta.mediana<-apply(datos,2,mad,na.rm=TRUE)
 error.estandar<-apply(datos,2,eestd)
 CV<-apply(datos,2,coefvar)
 RIC<-apply(datos,2,IQR,na.rm=T)
 asimetria<-apply(datos,2,skewness,na.rm=TRUE)
 curtosis<-apply(datos,2,kurtosis,na.rm=TRUE)
 ctiles<-apply(datos,2,quantile,na.rm=TRUE,probs=cuantiles)
 # Concatenacin de los estadsticos en varias columnas
 resultado<-rbind(N,noNA,minimo,maximo,media,mediaAcotada,
                  mediaGeometrica,mediaArmonica,
                  moda,tipo.de.moda,mediana,
                  amplitud,cuasivarianza,varianza,
                  cuasidesviacion.estandar,desviacion.estandar,
                  desviacion.absoluta.media,
                  desviacion.absoluta.mediana,
                  error.estandar,
                  CV, RIC,
                  asimetria,curtosis)
 ctiles<-data.frame(ctiles)
 row.names(ctiles)<-paste("Cuantil",cuantiles,sep="_")
 resultado<-data.frame(t(data.frame(resultado)),t(data.frame(ctiles)))
 return(resultado)
}

if (length(agrupa)>=2 & !is.null(agrupa) ){
datos$grupos<-factor(apply(apply(datos[,agrupa],2,as.character),1,paste,collapse="-"))
}else {if (is.null(agrupa)) datos$grupos<-NULL else datos$grupos<-factor(datos[,agrupa])}

resultados<-NULL
if (is.null(agrupa)){
 resultados<-estadisticos(datos[,variables])
}else
{
 for (i in levels(datos$grupos)){
   r1<-estadisticos(subset(datos[,variables],datos$grupos==i))
   r2<-data.frame(IDgrupo=rep(i,nrow(r1)),r1)
   resultados<-rbind(resultados,r2)
  }
}

vars<-factor(rep(variables,nrow(resultados)/length(variables)))
resultados<-data.frame(variables=vars,resultados)

for (i in names(resultados)){
 if (i!="variables" & i!="IDgrupo" & i!="tipo.de.moda") resultados[,i]<-as.numeric(as.character(resultados[,i]))
}

# Procedimiento para las medias ponderadas

resultadosp<-NULL
if (!is.null(variablepeso) & !is.null(variablespondera) & length(variablepeso)>=1){
  if (length(agrupapondera)>=1){
    # Seccin para cuando existe variables de agrupacin para la ponderacin
    datosp<-na.omit(datos[,c(variablespondera,variablepeso,agrupapondera)])
    # Crear una variable de grupos de acuerdo si es una o varias las
    # variables de agrupacin.
    if (length(agrupapondera)>=2){
      datosp$grupos<-factor(apply(apply(datosp[,agrupapondera],2,as.character),1,paste,collapse="-"))
      }else datosp$grupos<-factor(datosp[,agrupapondera])
    # Ciclo que reocorre todos los grupos
    for (i in levels(datosp$grupos)){
        if (length(variablespondera)>=2){
            #Para cuando existen ms de dos variables de ponderacin
            if (length(variablepeso)==1){
            resultadosp<-rbind(resultadosp,
                        apply(datosp[datosp$grupos==i,variablespondera],2,weighted.mean,datosp[datosp$grupos==i,variablepeso]))
            }else{
            r1<-NULL
            for (j in 1:length(variablepeso)){
                r1<-rbind(r1,
                        apply(datosp[datosp$grupos==i,variablespondera],2,weighted.mean,datosp[datosp$grupos==i,variablepeso[j]]))
             }
            r1<-data.frame(r1,poderada.por=variablepeso)
            resultadosp<-rbind(resultadosp,r1)
            }
          }else{
           # Para cuando existe una sola variable de ponderacin
           if (length(variablepeso)==1){
           resultadosp<-rbind(resultadosp,
                        weighted.mean(datosp[datosp$grupos==i,variablespondera],datosp[datosp$grupos==i,variablepeso]))     
           }else{
           r1<-NULL
           for (j in 1:length(variablepeso)){
                r1<-rbind(r1,
                        apply(data.frame(datosp[datosp$grupos==i,variablespondera]),2,weighted.mean,datosp[datosp$grupos==i,variablepeso[j]]))
           }
           r1<-data.frame(r1,poderada.por=variablepeso)
           resultadosp<-rbind(resultadosp,r1)
           }
          }
      }
     if (length(variablepeso)==1){
          IDgrupos=levels(datosp$grupos)
     }else{
         IDgrupos=rep(levels(datosp$grupos),each=length(variablepeso))
     }
     resultadosp<-data.frame(IDgrupos,resultadosp)
     if (length(variablespondera)==1) names(resultadosp)[2]<-variablespondera
    }
   else
   {
    # Seccin para cuando no existe variables de agrupacin
    datosp<-na.omit(datos[,c(variablespondera,variablepeso)])
    if (length(variablespondera)==1){
    # Seccin para cuando la variable de ponderacin es una sola
	if (length(variablepeso)==1){        
	resultadosp<-weighted.mean(datosp[,variablespondera],datosp[,variablepeso])
	resultadosp<-data.frame(resultadosp)
	names(resultadosp)<-variablespondera
        }else{
        r1<-NULL
        for (j in 1:length(variablepeso)){
           r1<-rbind(r1,weighted.mean(datosp[,variablespondera],datosp[,variablepeso[j]]))
        }
        r1<-data.frame(r1,ponderada.por=variablepeso)
        names(r1)[1]<-variablespondera
        resultadosp<-rbind(resultadosp,r1)        
      }
    }else{
    # Seccin para varias variables de ponderacin
    if (length(variablepeso)==1){
      resultadosp<-apply(datosp[,variablespondera],2,weighted.mean,datosp[,variablepeso])
    }else{
      r1<-NULL
      for (j in 1:length(variablepeso)){
	  r1<-rbind(r1,
		  apply(data.frame(datosp[,variablespondera]),2,weighted.mean,datosp[,variablepeso[j]]))
      }
      r1<-data.frame(r1,poderada.por=variablepeso)
      resultadosp<-rbind(resultadosp,r1)        
    }
    }
   }
}else
{
 mensaje<-c("\nNo se realiza el procedimiento de la media ponderada\n")
}





########################################################
# Seccin que muestra los resultados
########################################################

resultados

write.csv2(resultados,nombreArchivoSalida,row.names=FALSE)

if(!is.null(variablepeso) & !is.null(variablespondera)){
 print(resultadosp)
 write.csv2(resultadosp,nombreArchivoSalidaPondera,row.names=FALSE)
}else
{
 print(cat(mensaje))
}




